/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.FollowModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardJobSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardTaskSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.PatrolModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.moduleviews.SettingsModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuildingWorker
implements IGuardBuilding {
    public static final ISettingKey<GuardJobSetting> JOB = new SettingKey<GuardJobSetting>(GuardJobSetting.class, new ResourceLocation("minecolonies", "guardjob"));
    public static final ISettingKey<BoolSetting> RETREAT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "retreat"));
    public static final ISettingKey<BoolSetting> HIRE_TRAINEE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "hiretrainee"));
    public static final ISettingKey<PatrolModeSetting> PATROL_MODE = new SettingKey<PatrolModeSetting>(PatrolModeSetting.class, new ResourceLocation("minecolonies", "patrolmode"));
    public static final ISettingKey<FollowModeSetting> FOLLOW_MODE = new SettingKey<FollowModeSetting>(FollowModeSetting.class, new ResourceLocation("minecolonies", "followmode"));
    public static final ISettingKey<GuardTaskSetting> GUARD_TASK = new SettingKey<GuardTaskSetting>(GuardTaskSetting.class, new ResourceLocation("minecolonies", "guardtask"));
    private static final String NBT_JOB = "guardType";
    private static final String NBT_PATROL_TARGETS = "patrol targets";
    private static final String NBT_TARGET = "target";
    private static final String NBT_GUARD = "guard";
    private static final String NBT_MINE_POS = "minePos";
    private static final int PATROL_BASE_DIST = 50;
    private static final int BONUS_HEALTH_PER_LEVEL = 2;
    private static final int VISION_RANGE_PER_LEVEL = 3;
    private static final int BASE_VISION_RANGE = 15;
    private BlockPos guardPos = this.getID();
    protected List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private PlayerEntity followPlayer;
    private ILocation rallyLocation;
    protected BlockPos tempNextPatrolPoint = null;
    private PathResult pathResult;
    private BlockPos minePos;
    public static final String HOSTILE_LIST = "hostiles";
    private final Set<AbstractEntityCitizen> arrivedAtPatrol = new HashSet<AbstractEntityCitizen>();
    private BlockPos lastPatrolPoint;
    private int patrolTimer = 0;

    public AbstractBuildingGuards(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.doesItemServeAsWeapon(itemStack), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.FEET, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack).booleanValue() || !(itemStack.func_77973_b() instanceof ArrowItem)) {
                return false;
            }
            return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0 && this.getGuardType() == ModGuardTypes.ranger;
        }, new Tuple((Object)128, (Object)true));
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.getGuardType();
        if (this.getAssignedEntities() != null) {
            for (Optional<AbstractEntityCitizen> optCitizen : this.getAssignedEntities()) {
                if (!optCitizen.isPresent()) continue;
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), AttributeModifier.Operation.ADDITION);
                AttributeModifierUtils.addHealthModifier((LivingEntity)optCitizen.get(), healthModBuildingHP);
            }
        }
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building;
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            if (optCitizen.isPresent()) {
                AbstractEntityCitizen citizenEntity = optCitizen.get();
                AttributeModifierUtils.addHealthModifier((LivingEntity)citizenEntity, new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), AttributeModifier.Operation.ADDITION));
                AttributeModifierUtils.addHealthModifier((LivingEntity)citizenEntity, new AttributeModifier("MinecoloniesGuardConfigHP", (Double)MineColonies.getConfig().getServer().guardHealthMult.get() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((building = citizen.getHomeBuilding()) != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            this.patrolTimer = 5;
            return true;
        }
        return false;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b(NBT_JOB)) {
            this.getSetting(JOB).set(compound.func_74779_i(NBT_JOB));
        }
        ListNBT wayPointTagList = compound.func_150295_c(NBT_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundNBT blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, NBT_TARGET);
            this.patrolTargets.add(pos);
        }
        this.guardPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(NBT_GUARD));
        if (compound.func_74764_b(NBT_MINE_POS)) {
            this.minePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(NBT_MINE_POS));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT wayPointTagList = new ListNBT();
        for (BlockPos pos : this.patrolTargets) {
            CompoundNBT wayPointCompound = new CompoundNBT();
            BlockPosUtil.write(wayPointCompound, NBT_TARGET, pos);
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.func_218657_a(NBT_PATROL_TARGETS, (INBT)wayPointTagList);
        compound.func_218657_a(NBT_GUARD, (INBT)NBTUtil.func_186859_a((BlockPos)this.guardPos));
        if (this.minePos != null) {
            compound.func_218657_a(NBT_MINE_POS, (INBT)NBTUtil.func_186859_a((BlockPos)this.minePos));
        }
        return compound;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen != null) {
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            if (optCitizen.isPresent()) {
                AttributeModifierUtils.removeAllHealthModifiers((LivingEntity)optCitizen.get());
                optCitizen.get().func_184201_a(EquipmentSlotType.CHEST, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.FEET, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.LEGS, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
            }
            citizen.setHomeBuilding(null);
        }
        super.removeCitizen(citizen);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            buf.func_179255_a(pos);
        }
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
        if (this.minePos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.minePos);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public String getTask() {
        return this.getSetting(GUARD_TASK).getValue();
    }

    @Override
    @Nullable
    public PlayerEntity getPlayerToFollowOrRally() {
        return this.rallyLocation != null && this.rallyLocation instanceof EntityLocation ? ((EntityLocation)this.rallyLocation).getPlayerEntity() : this.followPlayer;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        boolean hiredFromTraining = false;
        if (this.getSetting(HIRE_TRAINEE).getValue() && !this.isFull() && this.getBuildingLevel() > 0 && this.isBuilt() && (this.getHiringMode() == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            ICitizenData trainingCitizen = null;
            int maxSkill = 0;
            for (ICitizenData trainee : colony.getCitizenManager().getCitizens()) {
                if ((this.getGuardType() != ModGuardTypes.ranger || !(trainee.getJob() instanceof JobArcherTraining)) && (this.getGuardType() != ModGuardTypes.knight || !(trainee.getJob() instanceof JobCombatTraining) || trainee.getCitizenSkillHandler().getLevel(this.getGuardType().getPrimarySkill()) <= maxSkill)) continue;
                maxSkill = trainee.getCitizenSkillHandler().getLevel(this.getGuardType().getPrimarySkill());
                trainingCitizen = trainee;
            }
            if (trainingCitizen != null) {
                hiredFromTraining = true;
                this.assignCitizen(trainingCitizen);
            }
        }
        if (!hiredFromTraining) {
            super.onColonyTick(colony);
        }
        if (this.patrolTimer > 0 && this.getSetting(GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.patrol")) {
            --this.patrolTimer;
            if (this.patrolTimer <= 0 && !this.getAssignedCitizen().isEmpty()) {
                this.startPatrolNext();
            }
        }
    }

    public void onJobChange() {
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            this.cancelAllRequestsOfCitizen(citizen);
            citizen.setJob(this.createJob(citizen));
        }
    }

    @Override
    public boolean requiresManualTarget() {
        return false;
    }

    @Override
    public void arrivedAtPatrolPoint(AbstractEntityCitizen guard) {
        if (this.arrivedAtPatrol.isEmpty()) {
            this.patrolTimer = 1;
        }
        this.arrivedAtPatrol.add(guard);
        if (this.getAssignedCitizen().size() <= this.arrivedAtPatrol.size() || this.patrolTimer <= 0) {
            this.startPatrolNext();
        }
    }

    private void startPatrolNext() {
        this.getNextPatrolTarget(true);
        this.patrolTimer = 5;
        for (ICitizenData curguard : this.getAssignedCitizen()) {
            if (!curguard.getEntity().isPresent() || !(curguard.getEntity().get().getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard)) continue;
            ((AbstractEntityAIGuard)((Object)curguard.getEntity().get().getCitizenJobHandler().getColonyJob().getWorkerAI())).setNextPatrolTarget(this.lastPatrolPoint);
        }
        this.arrivedAtPatrol.clear();
    }

    @Override
    @Nullable
    public BlockPos getNextPatrolTarget(boolean newTarget) {
        if (!newTarget && this.lastPatrolPoint != null) {
            return this.lastPatrolPoint;
        }
        if (this.tempNextPatrolPoint != null) {
            this.lastPatrolPoint = this.tempNextPatrolPoint;
            this.tempNextPatrolPoint = null;
            return this.lastPatrolPoint;
        }
        if (this.lastPatrolPoint == null) {
            this.lastPatrolPoint = this.getAssignedCitizen().get(0).getLastPosition();
            return this.lastPatrolPoint;
        }
        if (!this.getSetting(PATROL_MODE).getValue().equals(PatrolModeSetting.MANUAL) || this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            BlockPos pos = null;
            if (this.pathResult != null) {
                if (this.pathResult.isDone()) {
                    if (this.pathResult.getPath() != null) {
                        pos = this.pathResult.getPath().func_224770_k();
                    }
                    this.pathResult = null;
                }
            } else if (this.colony.getWorld().field_73012_v.nextBoolean()) {
                PathJobRandomPos job = new PathJobRandomPos(this.colony.getWorld(), this.lastPatrolPoint, 20, 40, null);
                this.pathResult = job.getResult();
                Pathfinding.enqueue(job);
            } else {
                pos = this.colony.getBuildingManager().getRandomBuilding(b -> true);
            }
            if (pos != null) {
                if (BlockPosUtil.getDistance2D(pos, this.getPosition()) > (long)this.getPatrolDistance()) {
                    this.lastPatrolPoint = this.getPosition();
                    return this.lastPatrolPoint;
                }
                this.lastPatrolPoint = pos;
            }
            return this.lastPatrolPoint;
        }
        if (this.patrolTargets.contains(this.lastPatrolPoint)) {
            int index = this.patrolTargets.indexOf(this.lastPatrolPoint) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            this.lastPatrolPoint = this.patrolTargets.get(index);
            return this.lastPatrolPoint;
        }
        this.lastPatrolPoint = this.patrolTargets.get(0);
        return this.lastPatrolPoint;
    }

    @Override
    public int getPatrolDistance() {
        return 50 + this.getBuildingLevel() * 30;
    }

    public void setTempNextPatrolPoint(BlockPos pos) {
        this.tempNextPatrolPoint = pos;
    }

    @Override
    public BlockPos getMinePos() {
        return this.minePos;
    }

    public void setMinePos(BlockPos pos) {
        if (pos == null) {
            this.minePos = null;
        } else if (this.colony.getBuildingManager().getBuilding(pos) instanceof BuildingMiner) {
            this.minePos = pos;
        }
    }

    @Override
    public GuardType getGuardType() {
        return this.getSetting(JOB).getGuardType();
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return this.getGuardType().getGuardJobProducer().apply(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return this.getGuardType().getJobTranslationKey();
    }

    @Override
    public boolean shallRetrieveOnLowHealth() {
        return this.getSetting(RETREAT).getValue();
    }

    @Override
    public boolean shallPatrolManually() {
        return this.getSetting(PATROL_MODE).getValue().equals(PatrolModeSetting.MANUAL);
    }

    @Override
    public boolean isTightGrouping() {
        return this.getSetting(FOLLOW_MODE).getValue().equals(FollowModeSetting.TIGHT);
    }

    @Override
    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    @Override
    public void setGuardPos(BlockPos guardPos) {
        this.guardPos = guardPos;
    }

    @Override
    public BlockPos getPositionToFollow() {
        if (this.getSetting(GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.follow") && this.followPlayer != null) {
            return new BlockPos(this.followPlayer.func_213303_ch());
        }
        return this.getPosition();
    }

    @Override
    @Nullable
    public ILocation getRallyLocation() {
        if (this.rallyLocation == null) {
            return null;
        }
        boolean outOfRange = false;
        IColony colonyAtPosition = IColonyManager.getInstance().getColonyByPosFromDim(this.rallyLocation.getDimension(), this.rallyLocation.getInDimensionLocation());
        if (colonyAtPosition == null || colonyAtPosition.getID() != this.colony.getID()) {
            outOfRange = true;
        }
        if (this.rallyLocation instanceof EntityLocation) {
            PlayerEntity player = ((EntityLocation)this.rallyLocation).getPlayerEntity();
            if (player == null) {
                this.setRallyLocation(null);
                return null;
            }
            if (outOfRange) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.banner_rally_guards.outofrange", (Object[])new Object[0]);
                this.setRallyLocation(null);
                return null;
            }
            int size = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBannerRallyGuards) || !((ItemBannerRallyGuards)stack.func_77973_b()).isActiveForGuardTower(stack, this)) continue;
                return this.rallyLocation;
            }
            return null;
        }
        return this.rallyLocation;
    }

    @Override
    public void setRallyLocation(ILocation location) {
        boolean reduceSaturation = false;
        if (this.rallyLocation != null && location == null) {
            reduceSaturation = true;
        }
        this.rallyLocation = location;
        for (ICitizenData iCitizenData : this.getAssignedCitizen()) {
            if (!reduceSaturation || !(iCitizenData.getSaturation() < 6.0)) continue;
            iCitizenData.decreaseSaturation(6.0);
        }
    }

    @Override
    public void setPlayerToFollow(PlayerEntity player) {
        this.followPlayer = player;
        for (ICitizenData iCitizenData : this.getAssignedCitizen()) {
            AbstractJobGuard job = iCitizenData.getJob(AbstractJobGuard.class);
            if (job == null || job.getWorkerAI() == null) continue;
            ((AbstractEntityAIGuard)job.getWorkerAI()).registerTarget(new AIOneTimeEventTarget(AIWorkerState.PREPARING));
        }
    }

    protected int getBonusHealth() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    @Override
    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList<BlockPos>();
        this.markDirty();
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return this.getGuardType().getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return this.getGuardType().getSecondarySkill();
    }

    @Override
    public int getBonusVision() {
        return 15 + this.getBuildingLevel() * 3;
    }

    @Override
    public void calculateMobs() {
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    public static class View
    extends AbstractBuildingWorkerView {
        private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
        @NotNull
        private final List<Integer> guards = new ArrayList<Integer>();
        private BlockPos minePos;

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, this.getSchematicName());
        }

        @NotNull
        public List<Integer> getGuards() {
            return Collections.unmodifiableList(this.guards);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            int targetSize = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < targetSize; ++i) {
                this.patrolTargets.add(buf.func_179259_c());
            }
            this.guards.clear();
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.guards.add(buf.readInt());
            }
            this.minePos = buf.readBoolean() ? buf.func_179259_c() : null;
        }

        @Override
        @NotNull
        public Skill getPrimarySkill() {
            return this.getGuardType().getPrimarySkill();
        }

        @Override
        @NotNull
        public Skill getSecondarySkill() {
            return this.getGuardType().getSecondarySkill();
        }

        public GuardType getGuardType() {
            return (GuardType)IGuardTypeRegistry.getInstance().getValue(new ResourceLocation(this.getModuleView(SettingsModuleView.class).getSetting(JOB).getValue()));
        }

        public List<BlockPos> getPatrolTargets() {
            return new ArrayList<BlockPos>(this.patrolTargets);
        }

        public BlockPos getMinePos() {
            return this.minePos;
        }

        public void setMinePos(BlockPos pos) {
            this.minePos = pos;
        }
    }
}

